<?php

$item_id = intval(str_replace("item_", "", $data));

$stmt = $pdo->prepare("SELECT title, price FROM items WHERE id = ?");
$stmt->execute([$item_id]);
$item = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$item) {
    sendMessage($chat_id, "❌ آیتم نامعتبر است.");
    return;
}

$keyboard = [
    'inline_keyboard' => [
        [
            ['text' => '➕ 1', 'callback_data' => "qty_{$item_id}_1"],
            ['text' => '➕ 5', 'callback_data' => "qty_{$item_id}_5"],
            ['text' => '➕ 10', 'callback_data' => "qty_{$item_id}_10"]
        ],
        [
            ['text' => '🔙 بازگشت', 'callback_data' => "game_items_back"]
        ]
    ]
];

sendMessage(
    $chat_id,
    "📦 آیتم: <b>{$item['title']}</b>\n💰 قیمت واحد: {$item['price']} تومان\n\nمقدار را انتخاب کنید:",
    $keyboard
);