<?php

$stmt = $pdo->prepare("
    SELECT o.id, o.total_price, o.status
    FROM orders o
    JOIN users u ON o.user_id = u.id
    WHERE u.telegram_id = ?
    ORDER BY o.id DESC
");
$stmt->execute([$callback['from']['id']]);
$orders = $stmt->fetchAll(PDO::FETCH_ASSOC);

if (!$orders) {
    sendMessage(
        $chat_id,
        "🧾 هنوز سفارشی ثبت نکرده‌اید.",
        [
            'inline_keyboard' => [
                [['text' => '🎮 شروع خرید', 'callback_data' => 'show_games']]
            ]
        ]
    );
    return;
}

$inline = [];
foreach ($orders as $o) {
    $statusMap = [
        'pending' => '⏳ در انتظار پرداخت',
        'paid' => '💰 پرداخت شد',
        'processing' => '⚙️ در حال انجام',
        'completed' => '✅ تکمیل شد',
        'rejected' => '❌ رد شد'
    ];

    $inline[] = [
        [
            'text' => "🧾 سفارش #{$o['id']} | {$statusMap[$o['status']]}",
            'callback_data' => "order_{$o['id']}"
        ]
    ];
}

$inline[] = [
    ['text' => '🔙 منوی اصلی', 'callback_data' => 'start']
];

sendMessage(
    $chat_id,
    "🧾 سفارشات شما:",
    ['inline_keyboard' => $inline]
);