<?php

$stmt = $pdo->query("SELECT id, title FROM games WHERE status = 1 ORDER BY id ASC");
$games = $stmt->fetchAll(PDO::FETCH_ASSOC);

if (!$games) {
    sendMessage($chat_id, "❌ هیچ بازی فعالی وجود ندارد.");
    return;
}

$inline = [];

foreach ($games as $game) {
    $inline[] = [
        [
            'text' => "🎮 " . $game['title'],
            'callback_data' => "game_" . $game['id']
        ]
    ];
}

$keyboard = ['inline_keyboard' => $inline];

sendMessage(
    $chat_id,
    "🎯 بازی مورد نظر را انتخاب کنید:",
    $keyboard
);